<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        
        <!-- App Favicon -->
        <link rel="shortcut icon" href="<?php echo e(url('assets/images/favicon.ico')); ?>">

        <!-- App title -->
        <title>Fluguto</title>

        <!-- App CSS -->
        <link href="<?php echo e(url('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(url('assets/css/core.css')); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(url('assets/css/components.css')); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(url('assets/css/icons.css')); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(url('assets/css/pages.css')); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(url('assets/css/menu.css')); ?>" rel="stylesheet" type="text/css" />
        <link href="<?php echo e(url('assets/css/responsive.css')); ?>" rel="stylesheet" type="text/css" />

        <!-- HTML5 Shiv and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
        <![endif]-->

        <script src="<?php echo e(url('assets/js/modernizr.min.js')); ?>"></script>
        
    </head>
    <body>

        <div class="account-pages"></div>
        <div class="clearfix"></div>
        <div class="wrapper-page">
            <div class="text-center">
                <a class="logo">
					<img src="<?php echo e(url('assets/images/logo.png')); ?>" />
					<!--<span>Flugu<span>to</span></span>-->
				</a>
                <h5 class="text-muted m-t-0 font-600">Portal Titulos Clientes</h5>
            </div>
        	<div class="m-t-40 card-box">
                <div class="text-center">
                    <h4 class="text-uppercase font-bold m-b-0">Login</h4>
                </div>
                <div class="panel-body">
                    <form class="form-horizontal m-t-20" role="form" method="POST" action="<?php echo e(url('/login_alt')); ?>">
                        <?php echo e(csrf_field()); ?>

                        <div class="form-group <?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
                            <div class="col-xs-12">
                                <input class="form-control" id="email" type="text" name="email" value="<?php echo e(old('email')); ?>" required autofocus placeholder="E-mail ou CNPJ/CPF">
                                
                                <?php if($errors->has('email')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('email')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                        
                        <?php if(session('mensagem')): ?>
                        <div class="form-group has-error">
                            <div class="col-xs-12">
                                <span class="help-block">
                                    <strong><?php echo e(session('mensagem')); ?></strong>
                                </span>
                            </div>
                        </div>
                        <?php endif; ?>
                        
                        <div class="form-group<?php echo e($errors->has('password') ? ' has-error' : ''); ?>">
                            <div class="col-xs-12">
                                <input id="password" type="password" class="form-control" name="password" required="" placeholder="Senha">
                                
                                
                                <?php if($errors->has('password')): ?>
                                    <span class="help-block">
                                        <strong><?php echo e($errors->first('password')); ?></strong>
                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="form-group ">
                            <div class="col-xs-12">
                                <div class="checkbox checkbox-custom">
                                    <input id="checkbox-signup" type="checkbox" name="remember">
                                    <label for="checkbox-signup">
                                        Lembrar-me
                                    </label>
                                </div>

                            </div>
                        </div>

                        <div class="form-group text-center m-t-30">
                            <div class="col-xs-12">
                                <button class="btn btn-custom btn-bordred btn-block waves-effect waves-light" type="submit">Logar</button>
                            </div>
                        </div>

                        <div class="form-group m-t-30 m-b-0">
                            <div class="col-sm-12">
                                <a href="<?php echo e(url('/password/reset')); ?>" class="text-muted">
                                    <i class="fa fa-lock m-r-5"></i> Recuperar sua senha?
                                </a>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
            <!-- end card-box-->

            <div class="row">
                <div class="col-sm-12 text-center">
                    <p class="text-muted">Ainda não tem uma conta? <a href="<?php echo e(url('/register')); ?>" class="text-primary m-l-5"><b>Cadastrar</b></a></p>
                </div>
            </div>
            
        </div>
        <!-- end wrapper page -->
        

        
    	<script>
            var resizefunc = [];
        </script>

        <!-- jQuery  -->
        <script src="<?php echo e(url('assets/js/jquery.min.js')); ?>"></script>
        <script src="<?php echo e(url('assets/js/bootstrap.min.js')); ?>"></script>
        <script src="<?php echo e(url('assets/js/detect.js')); ?>"></script>
        <script src="<?php echo e(url('assets/js/fastclick.js')); ?>"></script>
        <script src="<?php echo e(url('assets/js/jquery.slimscroll.js')); ?>"></script>
        <script src="<?php echo e(url('assets/js/jquery.blockUI.js')); ?>"></script>
        <script src="<?php echo e(url('assets/js/waves.js')); ?>"></script>
        <script src="<?php echo e(url('assets/js/wow.min.js')); ?>"></script>
        <script src="<?php echo e(url('assets/js/jquery.nicescroll.js')); ?>"></script>
        <script src="<?php echo e(url('assets/js/jquery.scrollTo.min.js')); ?>"></script>

        <!-- App js -->
        <script src="<?php echo e(url('assets/js/jquery.core.js')); ?>"></script>
        <script src="<?php echo e(url('assets/js/jquery.app.js')); ?>"></script>
	
	</body>
</html>