﻿@extends('layouts.app')

@section('content')
<!-- Page-Title -->
<div class="row">
    <div class="col-sm-12">
        <ol class="breadcrumb">
            <li><a href="{{url('')}}"><span class="m-l-5"><i class="fa fa-home"></i></span>&nbsp;Início</a></li>
            <li class="active">Titulos</li>
        </ol>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="card-box table-responsive">
            <table id="datatable-normal" class="table table-alt table-striped table-bordered">
                @if (Auth::user()->tipo == 2) 
                <thead>
                    <tr>
                        <th>Prefixo</th>
                        <th>Número</th>
                        <th>Parcela</th>
                        <th>Data Emissão</th>
                        <th>Data Vencimento</th>
                        <th>Valor Titulo</th>
                        <th>Valor Receber</th>
                        <th width="8%"></th>
                    </tr>
                </thead>

                <tbody>
                    @foreach($titulos as $o)
                    <tr>
                        <td>{{$o->prefixo or ''}}</td>
                        <td>{{$o->numero or ''}}</td>
                        <td>{{$o->parcela or ''}}</td>
                        <td data-order="{{($o->data_emissao)}}">{{mostra_data($o->data_emissao)}}</td>
                        <td data-order="{{($o->data_vencimento)}}">{{mostra_data($o->data_vencimento)}}</td>
                        <td>{{mostra_valor($o->valor_titulo)}}</td>
                        <td>{{mostra_valor($o->valor_receber)}}</td>
                        <td>
                            <a @if(diff_data($o->data_vencimento, date('Y-m-d')) <= 60) href="{{url('/titulo/'.$o->id.'/boleto')}}" target="_blank" class="on-default edit-row" @else class="on-default edit-row btn-msg-boleto"  @endif >
                                <img src="{{url('assets/images/icon-boleto.png')}}"/>
                            </a>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                @else
                    <thead>
                    <tr>
                        <th width="20%">Cliente</th>
                        <th>Prefixo</th>
                        <th>Número</th>
                        <th>Parcela</th>
                        <th>Data Emissão</th>
                        <th>Data Vencimento</th>
                        <th>Valor Titulo</th>
                        <th>Valor Receber</th>
                        <th width="8%"></th>
                    </tr>
                </thead>

                <tbody>
                    @foreach($titulos as $o)
                    <tr>
                        <td>{{$o->razao_social or ''}}</td>
                        <td>{{$o->prefixo or ''}}</td>
                        <td>{{$o->numero or ''}}</td>
                        <td>{{$o->parcela or ''}}</td>
                        <td data-order="{{($o->data_emissao)}}">{{mostra_data($o->data_emissao)}}</td>
                        <td data-order="{{($o->data_vencimento)}}">{{mostra_data($o->data_vencimento)}}</td>
                        <td>{{mostra_valor($o->valor_titulo)}}</td>
                        <td>{{mostra_valor($o->valor_receber)}}</td>
                        <td>
                            <a href="{{url('/titulo/'.$o->id.'/boleto')}}" target="_blank" class="on-default edit-row">
                                  <img src="{{url('assets/images/icon-boleto.png')}}"/>
                            </a>
                            
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                
                @endif
            </table>
        </div>
    </div><!-- end col -->
</div>
<!-- end row -->
@endsection
