@extends('layouts.app')

@section('content')
<!-- Page-Title -->
<div class="row">
    <div class="col-sm-12">
        <ol class="breadcrumb">
            <li><a href="{{url('')}}"><span class="m-l-5"><i class="fa fa-home"></i></span>&nbsp;Início</a></li>
            <li class="active">Clientes</li>
        </ol>
    </div>
    <div class="col-sm-12">
        <h4 class="page-title">Clientes</h4>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="card-box table-responsive">
            <table id="datatable-normal" class="table table-striped table-bordered">
                <thead>
                    <tr>
                        <th width="30%">Nome</th>
                        <th>CNPJ/CPF</th>
                        <th>E-mail</th>
                    </tr>
                </thead>

                <tbody>
                    @foreach($clientes as $o)
                    <tr>
                        <td>{{$o->nome or ''}}</td>
                        <td>@if ($o->tipo_pessoa == 'J') {{$o->cnpj}} @else {{$o->cpf}}  @endif</td>
                        <td>{{$o->email or ''}}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div><!-- end col -->
</div>
<!-- end row -->
@endsection
