@extends('layouts.app')

@section('content')

<div class="row">
    <div class="col-sm-12">
        <ol class="breadcrumb">
            <li><a href="{{url('')}}"><i class="fa fa-home"></i></span>&nbsp;Início</a></li>
            <li><a href="{{url('/usuario/listar')}}">Usuários</a></li>
            <li class="active">Usuário</li>
        </ol>
    </div>
    <div class="col-sm-12">
        <h4 class="page-title"><?php echo (isset($usuario)) ? 'Editar': 'Cadastro de';?> Usuário</h4>
    </div>
</div>
                 
<div class="row">
    <div class="col-sm-12">
        <div class="card-box">
            <div class="row">
                <div class="col-lg-12">
                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form accept-charset="UTF-8"  class="form-horizontal" role="form" method="POST" action="<?php echo (!isset($usuario)) ? url("usuario/incluir") : url("usuario/" . $usuario->id . "/atualizar"); ?>">
                        <?php if (isset($usuario)) { ?>
                            <input type="hidden" name="_method" value="PUT" />
                        <?php } ?>
                        {{ csrf_field() }}
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12">
                                        <label class="">Nome Usuário</label>
                                    </div>
                                </div>
                                 <div class="row">
                                    <div class="col-md-8">
                                        <input type="text" name="nome_usuario" class="form-control" value="@if(count($errors) > 0){{ old("nome_usuario") }}@else{{$usuario->name or ''}}@endif" placeholder="Digite nome do usuário"/>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12">
                                        <label class="">E-mail</label>
                                    </div>
                                </div>
                                 <div class="row">
                                    <div class="col-md-8">
                                        <input type="text" name="email" class="form-control" value="@if(count($errors) > 0){{ old("email") }}@else{{$usuario->email or ''}}@endif" placeholder="Digite seu e-mail">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12">
                                        <label class="">Senha</label>
                                    </div>
                                </div>
                                 <div class="row">
                                    <div class="col-md-8">
                                        <input type="password" name="senha" class="form-control" value="" placeholder="Digite sua senha">
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-12">
                                        <label class="">&nbsp;</label>
                                    </div>
                                </div>
                                 <div class="row">
                                     <div class="col-md-8">
                                         <?php if (isset($usuario)) { ?>
                                             <div class="checkbox checkbox-primary">
                                                 <input id="status" name="status" type="checkbox" <?php echo isset($usuario->status) && ($usuario->status == 1) ? 'checked' : ''; ?>>
                                                 <label for="status">
                                                     Ativo
                                                 </label>
                                             </div>
                                         <?php } ?>
                                     </div>
                                </div>
                            </div>
                        </div>
                        
                        <br/>
                        <div class="row">
                            <div class="col-sm-12">
                                <label>Empresas Habilitadas</label>
                            </div>
                        </div>
                        
                         <?php
                            if (isset($usuario)) {
                                $arrayRelacao = [];
                                foreach ($usuario->usuario_empresa as $o) {
                                    $arrayRelacao[] = $o->empresa_id;
                                }
                            }
                        ?>
                        
                        <?php
                        $x=0;
                        foreach ($empresas as $o) {
                            ?>
                            <div class="row">
                                <div class="col-sm-12">
                                    <div class="checkbox checkbox-primary">
                                        <input id="idempresa{{$x}}" name="idempresa[]" value="<?php echo $o->id; ?>"  type="checkbox" <?php echo isset($usuario) && in_array($o->id, $arrayRelacao) ? 'checked' : '' ?>>
                                        <label for="idempresa{{$x}}">
                                            {{$o->nome or ''}}
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <?php
                            $x++;
                        }
                        ?>
                        <br/>
                        <div class="row text-right">
                            <div class="col-lg-12 ">
                                <button type="submit" class="btn btn-success waves-effect waves-light m-l-10 btn-md">Salvar</button>
                            </div>
                        </div>
                    </form>
                </div><!-- end col -->

                
            </div><!-- end row -->
        </div>
    </div><!-- end col -->
</div>

@endsection
