<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Titulo extends Model {

    public $timestamps = false;
    public $table = 'titulo';
    protected $fillable = [
        "empresa_id", "codigo_cliente", "filial", "prefixo", "numero", "parcela",
        "tipo", "loja", "codigo_portado", "agencia", "conta", "numero_titulo_banco",
        "data_emissao", "data_vencimento", "data_baixa", "valor_titulo", "valor_juros",
        "porcentagem_juros", "valor_multa", "valor_receber", "banco"
    ];

    public function empresa() {
        return $this->hasOne('App\Empresa', 'id', 'empresa_id');
    }

}
