<?php

namespace App\Http\Controllers;

use Auth;
use App\Titulo;
use App\Cliente;
use App\Empresa;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TituloController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }

    public function listar() {
        $id = Auth::user()->id;

        if (Auth::user()->tipo == 2) {
            $cliente = Cliente::where('user_id', '=', $id)->first();
            if (count($cliente) > 0) {
                $titulos = Titulo::where([['codigo_cliente', '=', $cliente->codigo], ['empresa_id', '=', $cliente->empresa_id]])->get();
                return view('lista_titulo', compact('titulos'));
            }
            return "Erro!";
        } else {
            //$empresa = Empresa::where('user_id', '=', $id)->first();

            $query = "SELECT titulo.*, cliente.razao_social FROM titulo "
                    . " INNER JOIN cliente ON cliente.codigo = titulo.codigo_cliente AND cliente.empresa_id = titulo.empresa_id"
                    . " WHERE titulo.empresa_id IN (SELECT id  FROM empresa WHERE user_id = '" . $id . "')";
            $titulos = DB::select($query);
            return view('lista_titulo', compact('titulos'));

            #if (count($empresa) > 0) {
            #    $titulos = Titulo::where('empresa_id', '=', $empresa->id)->get();
            #    return view('lista_titulo', compact('titulos'));
            #}
            #return "Erro!";
        }
    }

    public function gerar_boleto($id) {

        $titulo = Titulo::find($id);

        if ($titulo->banco != '756') {
            $banco = $titulo->banco;
            return view('banco_invalido', compact('banco'));
        }

        if ($titulo != null) {

            $cliente = Cliente::where([['codigo', '=', $titulo->codigo_cliente], ['empresa_id', '=', $titulo->empresa_id]])->first();


            $beneficiario = new \Eduardokum\LaravelBoleto\Pessoa(
                    [
                'nome' => strtoupper(trim($titulo->empresa->nome)),
                'endereco' => trim($titulo->empresa->endereco) . ", " . trim($titulo->empresa->numero),
                'bairro' => trim($titulo->empresa->bairro),
                'cep' => trim($titulo->empresa->cep),
                'uf' => trim($titulo->empresa->uf),
                'cidade' => trim($titulo->empresa->cidade),
                'documento' => trim($titulo->empresa->cnpj),
                    ]
            );

            $pagador = new \Eduardokum\LaravelBoleto\Pessoa(
                    [
                'nome' => trim($cliente->razao_social),
                'endereco' => trim($cliente->endereco) . ", " . trim($cliente->numero),
                'bairro' => trim($cliente->bairro),
                'cep' => $cliente->cep,
                'uf' => trim($cliente->uf),
                'cidade' => trim($cliente->cidade),
                'documento' => (($cliente->tipo_pessoa == 'F') ? trim($cliente->cpf) : trim($cliente->cnpj)),
                    ]
            );

            $dias = diff_data($titulo->data_vencimento, date('Y-m-d'));
            $data_vencimento = $titulo->data_vencimento;
            $valor = $titulo->valor_receber;
            $carteira = 5;
            $valor_juros = $titulo->valor_juros;
            if ($dias > 0) {
                $carteira = 1;
                $data_vencimento = date('Y-m-d');

                if ($titulo->valor_juros == 0) {
                    $valor_juros = 0.02;
                }
                $valor = ($titulo->valor_receber + $titulo->valor_multa) + ($valor_juros * $dias);
                //(VALOR + MULTA) + (JUROS * nDiasVencidos)
            }

            $boleto = new \Eduardokum\LaravelBoleto\Boleto\Banco\Bancoob(
                    [
                'dataDocumento' => new \Carbon\Carbon($titulo->data_emissao),
                'dataVencimento' => new \Carbon\Carbon($data_vencimento),
                'valor' => $valor,
                'multa' => false,
                'juros' => false,
                'numero' => intval(substr(trim($titulo->numero_titulo_banco), 0, -1)),
                'numeroDocumento' => trim($titulo->numero) . "/" . trim($titulo->parcela),
                'parcela' => (trim($titulo->parcela) != "") ? intval(trim($titulo->parcela)) : 1,
                'pagador' => $pagador,
                'beneficiario' => $beneficiario,
                'carteira' => $carteira,
                //'byte' => 2,
                'agencia' => trim($titulo->agencia),
                //'posto' => 11,
                'conta' => (trim($titulo->conta)),
                'convenio' => trim($titulo->conta), //trim($titulo->codigo_portado),
                'descricaoDemonstrativo' => ['', '', ''],
                'instrucoes' =>
                [
                    'Instruções (texto de responsabilidade do beneficiário)',
                    'Até o vencimento pagável em qualquer banco',
                    'NÃO RECEBER APÓS 30 DIAS DO VENCIMENTO',
                    'Após o vencimento, cobrar Multa de R$ ' . mostra_valor($titulo->valor_multa) . ' e Mora de R$ ' . mostra_valor($valor_juros) . ' ao dia',
                    'Documento Origem: ' . trim($titulo->parcela) . "-" . trim($titulo->numero),
                ],
                'aceite' => 'N',
                'especieDoc' => 'DM',
                    ]
            );

            $pdf = new \Eduardokum\LaravelBoleto\Boleto\Render\Pdf();
            $pdf->addBoleto($boleto);
            $pdf->gerarBoleto($pdf::OUTPUT_STANDARD);
        }
    }

}
