﻿

<?php $__env->startSection('content'); ?>
<!-- Page-Title -->
<div class="row">
    <div class="col-sm-12">
        <ol class="breadcrumb">
            <li><a href="<?php echo e(url('')); ?>"><span class="m-l-5"><i class="fa fa-home"></i></span>&nbsp;Início</a></li>
            <li class="active">Titulos</li>
        </ol>
    </div>
</div>

<div class="row">
    <div class="col-sm-12">
        <div class="card-box table-responsive">
            <table id="datatable-normal" class="table table-alt table-striped table-bordered">
                <?php if(Auth::user()->tipo == 2): ?> 
                <thead>
                    <tr>
                        <th>Prefixo</th>
                        <th>Número</th>
                        <th>Parcela</th>
                        <th>Data Emissão</th>
                        <th>Data Vencimento</th>
                        <th>Valor Titulo</th>
                        <th>Valor Receber</th>
                        <th width="8%"></th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $titulos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                    <tr>
                        <td><?php echo e(isset($o->prefixo) ? $o->prefixo : ''); ?></td>
                        <td><?php echo e(isset($o->numero) ? $o->numero : ''); ?></td>
                        <td><?php echo e(isset($o->parcela) ? $o->parcela : ''); ?></td>
                        <td data-order="<?php echo e(($o->data_emissao)); ?>"><?php echo e(mostra_data($o->data_emissao)); ?></td>
                        <td data-order="<?php echo e(($o->data_vencimento)); ?>"><?php echo e(mostra_data($o->data_vencimento)); ?></td>
                        <td><?php echo e(mostra_valor($o->valor_titulo)); ?></td>
                        <td><?php echo e(mostra_valor($o->valor_receber)); ?></td>
                        <td>
                            <a <?php if(diff_data($o->data_vencimento, date('Y-m-d')) <= 60): ?> href="<?php echo e(url('/titulo/'.$o->id.'/boleto')); ?>" target="_blank" class="on-default edit-row" <?php else: ?> class="on-default edit-row btn-msg-boleto"  <?php endif; ?> >
                                <img src="<?php echo e(url('assets/images/icon-boleto.png')); ?>"/>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                </tbody>
                <?php else: ?>
                    <thead>
                    <tr>
                        <th width="20%">Cliente</th>
                        <th>Prefixo</th>
                        <th>Número</th>
                        <th>Parcela</th>
                        <th>Data Emissão</th>
                        <th>Data Vencimento</th>
                        <th>Valor Titulo</th>
                        <th>Valor Receber</th>
                        <th width="8%"></th>
                    </tr>
                </thead>

                <tbody>
                    <?php $__currentLoopData = $titulos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $o): $__env->incrementLoopIndices(); $loop = $__env->getFirstLoop(); ?>
                    <tr>
                        <td><?php echo e(isset($o->razao_social) ? $o->razao_social : ''); ?></td>
                        <td><?php echo e(isset($o->prefixo) ? $o->prefixo : ''); ?></td>
                        <td><?php echo e(isset($o->numero) ? $o->numero : ''); ?></td>
                        <td><?php echo e(isset($o->parcela) ? $o->parcela : ''); ?></td>
                        <td data-order="<?php echo e(($o->data_emissao)); ?>"><?php echo e(mostra_data($o->data_emissao)); ?></td>
                        <td data-order="<?php echo e(($o->data_vencimento)); ?>"><?php echo e(mostra_data($o->data_vencimento)); ?></td>
                        <td><?php echo e(mostra_valor($o->valor_titulo)); ?></td>
                        <td><?php echo e(mostra_valor($o->valor_receber)); ?></td>
                        <td>
                            <a href="<?php echo e(url('/titulo/'.$o->id.'/boleto')); ?>" target="_blank" class="on-default edit-row">
                                  <img src="<?php echo e(url('assets/images/icon-boleto.png')); ?>"/>
                            </a>
                            
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getFirstLoop(); ?>
                </tbody>
                
                <?php endif; ?>
            </table>
        </div>
    </div><!-- end col -->
</div>
<!-- end row -->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>