<?php

/*
  |--------------------------------------------------------------------------
  | Web Routes
  |--------------------------------------------------------------------------
  |
  | This file is where you may define all of the routes that are handled
  | by your application. Just tell Laravel the URIs it should respond
  | to using a Closure or controller method. Build something great!
  |
 */


Route::get('/', function () {
    return redirect('login');
});


Auth::routes();

Route::get('/home', 'HomeController@index');
Route::post('/login_alt', 'AuthController@authenticate');

Route::group(['prefix' => 'usuario', 'where' => ['id' => '[0-9]+']], function() {

    Route::get('/listar', 'UsuarioController@listar');
    Route::get('/novo', 'UsuarioController@novo');
    Route::post('/incluir', 'UsuarioController@incluir'); //incluir banco
    Route::get('/{id}/excluir', 'UsuarioController@excluir');
    Route::get('/{id}/editar', 'UsuarioController@editar');
    Route::put('/{id}/atualizar', 'UsuarioController@atualizar'); //atualizar banco

    Route::get('/trocar_senha', 'UsuarioController@trocar_senha');
    Route::put('/atualizar_senha', 'UsuarioController@atualizar_senha'); //atualizar banco
});

Route::group(['prefix' => 'empresa', 'where' => ['id' => '[0-9]+']], function() {

    Route::get('/listar', 'EmpresaController@listar');
    Route::get('/novo', 'EmpresaController@novo');
    Route::post('/incluir', 'EmpresaController@incluir'); //incluir banco
    Route::get('/{id}/excluir', 'EmpresaController@excluir');
    Route::get('/{id}/editar', 'EmpresaController@editar');
    Route::put('/{id}/atualizar', 'EmpresaController@atualizar'); //atualizar banco
});


Route::group(['prefix' => 'cliente'], function() {
    Route::get('/listar', 'ClienteController@listar');
});

Route::group(['prefix' => 'titulo'], function() {
    Route::get('/listar', 'TituloController@listar');
    Route::get('/{id}/boleto', 'TituloController@gerar_boleto');
});