@extends('layouts.app')

@section('content')

<div class="row">
    <div class="col-sm-12">
        <ol class="breadcrumb">
            <li><a href="{{url('')}}"><i class="fa fa-home"></i></span>&nbsp;Início</a></li>
            <li class="active">Trocar Senha</li>
        </ol>
    </div>
    <div class="col-sm-12">
        <h4 class="page-title">Trocar Senha</h4>
    </div>
</div>

<div class="row">
    <div class="col-sm-6">
        <div class="card-box">
            <div class="row">
                <div class="col-lg-12">
                    @if (count($errors) > 0)
                    <div class="alert alert-danger">
                        <ul>
                            @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                    @if(session('mensagem'))
                    <div class="alert alert-danger">
                        <strong>Erro!</strong>
                        {{ session('mensagem') }}
                    </div>
                    @endif

                    <form accept-charset="UTF-8"  class="form-horizontal" role="form" method="POST" action="{{url('usuario/atualizar_senha')}}">
                        <input type="hidden" name="_method" value="PUT" />
                        {{ csrf_field() }}
                        <div class="row">
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12">
                                        <label class="">Senha Atual</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <input type="password" name="senha_atual" class="form-control" value="{{ old("senha_atual") }}" placeholder="Digite sua senha atual"/>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12">
                                        <label class="">Nova Senha</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <input type="password" name="nova_senha" class="form-control" value="{{ old("nova_senha") }}" placeholder="Digite sua nova senha"/>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="row">
                                    <div class="col-md-12">
                                        <label class="">Confirmação de Senha</label>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-12">
                                        <input type="password" name="confirmacao_senha" class="form-control" value="{{ old("confirmacao_senha") }}" placeholder="Confirmação de senha"/>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <br/>
                        <div class="row text-right">
                            <div class="col-lg-12 ">
                                <button type="submit" class="btn btn-success waves-effect waves-light m-l-10 btn-md">Salvar</button>
                            </div>
                        </div>
                    </form>
                </div><!-- end col -->
            </div><!-- end row -->
        </div>
    </div><!-- end col -->
</div>

@endsection
