<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <link rel="shortcut icon" href="{{url('assets/images/favicon.ico')}}">

        <!-- CSRF Token -->
        <meta name="csrf-token" content="{{ csrf_token() }}">


        <title>{{ config('app.name', 'Fluguto') }}</title>

        <!-- DataTables -->
        <link href="{{url('assets/plugins/datatables/jquery.dataTables.min.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{url('assets/plugins/datatables/buttons.bootstrap.min.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{url('assets/plugins/datatables/fixedHeader.bootstrap.min.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{url('assets/plugins/datatables/responsive.bootstrap.min.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{url('assets/plugins/datatables/scroller.bootstrap.min.css')}}" rel="stylesheet" type="text/css" />


        <!--Morris Chart CSS -->
        <link rel="stylesheet" href="{{url('assets/plugins/morris/morris.css')}}">
        
        <link href="{{url('assets/plugins/bootstrap-sweetalert/sweet-alert.css')}}" rel="stylesheet" type="text/css" />


        <link href="{{url('assets/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{url('assets/css/core.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{url('assets/css/components.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{url('assets/css/icons.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{url('assets/css/pages.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{url('assets/css/menu.css')}}" rel="stylesheet" type="text/css" />
        <link href="{{url('assets/css/responsive.css')}}" rel="stylesheet" type="text/css" />

        <link href="{{url('assets/css/my-style.css')}}" rel="stylesheet" type="text/css" />
        <!-- HTML5 Shiv and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.3.0/respond.min.js"></script>
        <![endif]-->

        <script src="{{url('assets/js/modernizr.min.js')}}"></script>

        <script>
                window.Laravel = <?php
            echo json_encode([
                'csrfToken' => csrf_token(),
            ]);
            ?>
        </script>
    </head>
    <body>
            <header id="topnav">
                <div class="topbar-main">
                    <div class="container">

                        <!-- LOGO -->
                        <div class="topbar-left">
                            <a href="{{url('')}}" class="logo">
								<!--<span>Flugu<span>to</span></span>-->
								<img src="{{url('assets/images/logo_negativa.png')}}" width="200" height="45"/>
							</a>
                        </div>
                        <!-- End Logo container-->


                        <div class="menu-extras">

                            <ul class="nav navbar-nav navbar-right pull-right">

                                <li class="dropdown user-box">
                                    <a href="" class="dropdown-toggle waves-effect waves-light profile " data-toggle="dropdown" aria-expanded="true">
                                        <!--<img src="{{url('assets/images/users/avatar-1.jpg')}}" alt="user-img" class="img-circle user-img">-->
                                         <i class="m-l-5 fa fa-cogs fa-3x text-success"></i>
                                        <div class="user-status away"><!--<i class="zmdi zmdi-dot-circle"></i>--></div>
                                    </a>

                                    <ul class="dropdown-menu">
                                        @if (Auth::user()->tipo == 1) 
                                            <li><a href="{{url('empresa/listar')}}"><i class="fa fa-building-o m-r-5"></i> Empresas</a></li>
                                            <li><a href="{{url('usuario/listar')}}"><i class="ti-user m-r-5"></i> Usuários</a></li>
                                        @endif
                                        <li><a href="{{url('usuario/trocar_senha')}}"><i class="ti-exchange-vertical m-r-5"></i> Trocar Senha</a></li>
                                        <li>
                                            <a href="{{ url('/logout') }}" onclick="event.preventDefault();
                                                 document.getElementById('logout-form').submit();"><i class="ti-power-off m-r-5"></i> Sair
                                            </a>

                                            <form id="logout-form" action="{{ url('/logout') }}" method="POST" style="display: none;">
                                                {{ csrf_field() }}
                                            </form>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                            <div class="menu-item">
                                <!-- Mobile menu toggle-->
                                <a class="navbar-toggle">
                                    <div class="lines">
                                        <span></span>
                                        <span></span>
                                        <span></span>
                                    </div>
                                </a>
                                <!-- End mobile menu toggle-->
                            </div>
                        </div>

                    </div>
                </div>

                <div class="navbar-custom">
                    <div class="container">
                        <div id="navigation">
                            <!-- Navigation Menu-->
                            <ul class="navigation-menu">
                                <!--<li class="active">
                                    <a href="{{url('/home')}}" class="active"><i class="zmdi zmdi-view-dashboard"></i> <span> Dashboard </span> </a>
                                </li>-->
                                <li class="active">
                                    <a href="{{url('/titulo/listar')}}" class="active"><i class="fa fa-barcode"></i> <span> Titulos </span> </a>
                                </li>
                                @if (Auth::user()->tipo == 1) 
                                    <li class="active">
                                        <a href="{{url('/cliente/listar')}}" class="active"><i class="fa fa-users"></i> <span> Cliente </span> </a>
                                    </li>
                                @endif
                            </ul>
                            <!-- End navigation menu  -->
                        </div>
                    </div>
                </div>
            </header>
            
            <div class="wrapper">
                <div class="container">
                    @yield('content')
                    
                    <!-- Footer -->
                    <footer class="footer text-right">
                        <div class="container">
                            <div class="row">

                            </div>
                        </div>
                    </footer>
                    <!-- End Footer -->

                </div>
            </div>
        

        <!-- Scripts -->
        <!-- jQuery  -->
        <script src="{{url('assets/js/jquery.min.js')}}"></script>
        <script src="{{url('assets/js/bootstrap.min.js')}}"></script>
        <script src="{{url('assets/js/detect.js')}}"></script>
        <script src="{{url('assets/js/fastclick.js')}}"></script>

        <script src="{{url('assets/js/jquery.slimscroll.js')}}"></script>
        <script src="{{url('assets/js/jquery.blockUI.js')}}"></script>
        <script src="{{url('assets/js/waves.js')}}"></script>
        <script src="{{url('assets/js/wow.min.js')}}"></script>
        <script src="{{url('assets/js/jquery.nicescroll.js')}}"></script>
        <script src="{{url('assets/js/jquery.scrollTo.min.js')}}"></script>

        <!-- KNOB JS -->
        <!--[if IE]>
        <script type="text/javascript" src="{{url('assets/plugins/jquery-knob/excanvas.js')}}"></script>
        <![endif]-->
        <script src="{{url('assets/plugins/jquery-knob/jquery.knob.js')}}"></script>

        
	<!-- Datatables-->
        <script src="{{url('assets/plugins/datatables/jquery.dataTables.min.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/dataTables.bootstrap.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/dataTables.buttons.min.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/buttons.bootstrap.min.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/jszip.min.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/pdfmake.min.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/vfs_fonts.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/buttons.html5.min.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/buttons.print.min.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/dataTables.fixedHeader.min.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/dataTables.keyTable.min.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/dataTables.responsive.min.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/responsive.bootstrap.min.js')}}"></script>
        <script src="{{url('assets/plugins/datatables/dataTables.scroller.min.js')}}"></script>

        <!-- Datatable init js -->
        <script src="{{url('assets/pages/datatables.init.js')}}"></script>
        <script src="{{url('assets/plugins/bootstrap-sweetalert/sweet-alert.min.js')}}"></script>
        <script src="{{url('assets/js/funcoes.js')}}"></script>
'       
        <!-- App js -->
        <script src="{{url('assets/js/jquery.core.js')}}"></script>
        <script src="{{url('assets/js/jquery.app.js')}}"></script>
        
        <script type="text/javascript">
            $(document).ready(function() {
            } );
            TableManageButtons.init();

        </script>
    </body>
</html>
