<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable {

    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'email', 'password', 'user_id', 'status', 'tipo', 'cnpj_cpf'
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password', 'remember_token',
    ];

    public function usuario_empresa() {
        return $this->hasMany('App\UsuarioEmpresa', 'user_id');
    }

    public function empresa() {
        return $this->hasMany('App\Empresa', 'user_id');
    }

    public function cliente() {
        return $this->hasMany('App\Cliente', 'user_id');
    }

}
