<?php

namespace App\Http\Controllers;

use Auth;
use App\Titulo;
use App\Cliente;
use App\Empresa;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TituloController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }

    public function listar() {
        $id = Auth::user()->id;

        if (Auth::user()->tipo == 2) {
            $cliente = Cliente::where('user_id', '=', $id)->first();
            if (count($cliente) > 0) {
                $titulos = Titulo::where([['codigo_cliente', '=', $cliente->codigo], ['empresa_id', '=', $cliente->empresa_id]])->get();
                return view('lista_titulo', compact('titulos'));
            }
            return "Erro!";
        } else {
            //$empresa = Empresa::where('user_id', '=', $id)->first();

            $query = "SELECT titulo.*, cliente.razao_social FROM titulo "
                    . " INNER JOIN cliente ON cliente.codigo = titulo.codigo_cliente AND cliente.empresa_id = titulo.empresa_id"
                    . " WHERE titulo.filial IN (SELECT filial FROM empresa WHERE user_id = '" . $id . "') LIMIT 100";
            $titulos = DB::select($query);
            
            //
            //echo $query;
            return view('lista_titulo', compact('titulos'));

            #if (count($empresa) > 0) {
            #    $titulos = Titulo::where('empresa_id', '=', $empresa->id)->get();
            #    return view('lista_titulo', compact('titulos'));
            #}
            #return "Erro!";
        }
    }

    public function gerar_boleto($id) {

        $titulo = Titulo::find($id);

        /*
        if ($titulo->banco != '756') {
            $banco = $titulo->banco;
            return view('banco_invalido', compact('banco'));
        }
        */

        if ($titulo != null) {

            $cliente = Cliente::where([['codigo', '=', $titulo->codigo_cliente], ['empresa_id', '=', $titulo->empresa_id]])->first();

            $empresa = Empresa::where([['filial', '=', $titulo->filial]])->first();
            //$query = "SELECT * FROM empresa WHERE filial LIKE '%".$titulo->filial."%'";
            //$empresa = DB::select($query);
            
            if ($empresa == null) {
                return "Empresa não encontrada!";
            }
            
            
            $beneficiario = new \Eduardokum\LaravelBoleto\Pessoa(
                    [
                'nome' => strtoupper(trim($empresa->nome)),
                'endereco' => trim($empresa->endereco).(trim($empresa->numero) == "")? "": ", " . trim($empresa->numero),
                'bairro' => trim($empresa->bairro),
                'cep' => trim($empresa->cep),
                'uf' => trim($empresa->uf),
                'cidade' => trim($empresa->cidade),
                'documento' => trim($empresa->cnpj),
                    ]
            );

            $pagador = new \Eduardokum\LaravelBoleto\Pessoa(
                    [
                'nome' => trim($cliente->razao_social),
                'endereco' => trim($cliente->endereco) . ", " . trim($cliente->numero),
                'bairro' => trim($cliente->bairro),
                'cep' => $cliente->cep,
                'uf' => trim($cliente->uf),
                'cidade' => trim($cliente->cidade),
                'documento' => (($cliente->tipo_pessoa == 'F') ? trim($cliente->cpf) : trim($cliente->cnpj)),
                    ]
            );

            $dias = diff_data($titulo->data_vencimento, date('Y-m-d'));
            $data_vencimento = $titulo->data_vencimento;
            $valor = $titulo->valor_receber;
            
            $carteira = 5;
            $parcela = (trim($titulo->parcela) != "") ? intval(trim($titulo->parcela)) : 1;
            
            if (trim($titulo->carteira) != '109') {
                $carteira = 1;
				$parcela = (trim($titulo->parcela) != "") ? intval(trim($titulo->parcela)) : 1;
                //$parcela = 1;
            }
            
            $valor_multa = $titulo->valor_multa;
            if ($titulo->valor_multa == 0) {
                $valor_multa = 0.02;
            }
            $valor_juros = ($titulo->valor_receber * 0.147) / 30;
            
            $instrucoes = [
                    'DEVOLVER APOS 30 DIAS VENCIDO',
                    'DOCUMENTO: '.trim($titulo->numero) . "/" . trim($titulo->parcela),
                    '',
                    'APOS VENCIMENTO, MULTA DE '.mostra_valor($valor_multa*100).' %',
                    'APOS VENCIMENTO, MORA/DIA DE R$ '.mostra_valor($valor_juros),
                    '',
                    '///ATENÇÃO ////SEGUNDA VIA'
            ];
            
            if ($dias > 0) {
                //$carteira = 1;
                $data_vencimento = date('Y-m-d');
                $valor = ($titulo->valor_receber + ($titulo->valor_receber * $valor_multa)) + ($valor_juros * $dias);
                
                $f1 = explode(".", $valor);
                $f1 = $f1[0].".".substr($f1[1],  0, 2);
                $valor = $f1;
                
                $encargos = ($titulo->valor_receber * ($valor_multa)) + ($valor_juros * $dias);
                $f1 = explode(".", $encargos);
                $f1 = $f1[0].".".substr($f1[1],  0, 2);
                $encargos = $f1;
                
                $instrucoes = [
                    'Válido para pagamento somente até o dia: '. mostra_data($data_vencimento),
                    'Vencimento original: '. mostra_data($titulo->data_vencimento),
                    'Valor original: R$ '. mostra_valor($titulo->valor_receber),
                    'Encargos por atraso: R$ '. mostra_valor($encargos),
                    'Valor atualizado: R$ '. mostra_valor($valor),
                    //$titulo->valor_receber * ($valor_multa).' -- '.($valor_juros * $dias)." == ".$valor,
                    '',
                    '///ATENÇÃO ////SEGUNDA VIA'
                ];
            }
            
            
            
            //$valor = 851.51;
			//$data_vencimento = '2018-03-27';
            
            $conta = explode("-", trim($titulo->conta));
            $conta = intval($conta[0])."-".intval($conta[1]);
            //$conta = trim($titulo->conta);

            if ($titulo->banco == '756') {
            
                $boleto = new \Eduardokum\LaravelBoleto\Boleto\Banco\Bancoob(
                        [
                            'dataDocumento' => new \Carbon\Carbon($titulo->data_emissao),
                            'dataVencimento' => new \Carbon\Carbon($data_vencimento),
                            'dataProcessamento' => new \Carbon\Carbon($titulo->data_emissao),
                            'valor' => $valor,
                            'multa' => false,
                            'juros' => false,
                            'numero' => intval(substr(trim($titulo->numero_titulo_banco), 0, -1)),
                            'digitoVerificador' => substr(trim($titulo->numero_titulo_banco), -1),         
                            'numeroDocumento' => trim($titulo->numero) . "/" . trim($titulo->parcela),// (trim($titulo->parcela))?trim($titulo->parcela): 1,
                            'parcela' => $parcela,//(trim($titulo->parcela) != "") ? intval(trim($titulo->parcela)) : 1,
                            'pagador' => $pagador,
                            'beneficiario' => $beneficiario,
                            'carteira' => $carteira,
                            //'byte' => 2,
                            'agencia' => substr(trim($titulo->agencia), 0, -2),
                            //'posto' => 11,
                            'conta' => $conta,//substr(trim($titulo->conta), 1 ),
                            'convenio' => $conta,//substr(trim($titulo->conta), 1 ), //trim($titulo->codigo_portado),
                            'descricaoDemonstrativo' => ['', '', ''],
                            'instrucoes' => $instrucoes
                            /*[
                                'Até o vencimento pagável em qualquer banco',
                                'NÃO RECEBER APÓS 30 DIAS DO VENCIMENTO',
                                'Após o vencimento, cobrar Multa de R$ ' . mostra_valor($valor_multa) . ' e Mora de R$ ' . mostra_valor($valor_juros) . ' ao dia',
                                'Documento Origem: ' . trim($titulo->parcela) . "-" . trim($titulo->numero),
                            ]*/,
                            'aceite' => 'N',
                            'especieDoc' => 'DM',
                        ]
                );
            
            } else if ($titulo->banco == '748') {

                $DataDocumento = "20" . substr(trim($titulo->numero_titulo_banco),0,2) . "-01-01";

                $boleto = new \Eduardokum\LaravelBoleto\Boleto\Banco\Sicredi(
                    [
                        'logo'                   => realpath(__DIR__ . '/../logos/') . DIRECTORY_SEPARATOR . '748.png',
                        'dataVencimento'         => new \Carbon\Carbon($data_vencimento),
                        'dataProcessamento'      => new \Carbon\Carbon($titulo->data_emissao),
                        'dataDocumento'          => new \Carbon\Carbon($DataDocumento),
                        // 'dataDocumento'          => new \Carbon\Carbon($titulo->data_emissao),
                        'valor'                  => $valor,
                        'multa'                  => false,
                        'juros'                  => false,
                        'numero'                 => trim($titulo->numero) . "/" . trim($titulo->parcela),
                        'numeroDocumento'        => intval(substr(trim($titulo->numero_titulo_banco),3,5)),
                        'pagador'                => $pagador,
                        'beneficiario'           => $beneficiario,
                        'carteira'               => $carteira,
                        'byte'                   => 2,
                        'agencia'                => substr(trim($titulo->agencia), 0, -2),
                        'posto'                  => 70,
                        'conta'                  => $conta,
                        'descricaoDemonstrativo' => ['', '', ''],
                        'instrucoes'             =>  $instrucoes,
                        'aceite'                 => 'N',
                        'especieDoc'             => 'DM',
                    ]
                );
                
                // var_dump($DataDocumento);

            }
            $pdf = new \Eduardokum\LaravelBoleto\Boleto\Render\Pdf();
            $pdf->addBoleto($boleto);
            $pdf->gerarBoleto($pdf::OUTPUT_STANDARD);
        }
    }

}
