<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use Validator;
use App\Empresa;


class EmpresaController extends Controller {

    public function __construct() {
        $this->middleware('auth');
    }

    public function listar() {
        $id = Auth::user()->id;
        $empresas = Empresa::where('user_id', '=', $id)->get();
        return view('lista_empresa', compact('empresas'));
    }

    public function novo() {
        return view('cad_empresa');
    }

    public function editar($id) {
        $empresa = Empresa::find($id);
        return view('cad_empresa', compact('empresa'));
    }

    public function incluir(Request $request) {

        $validator = Validator::make(
                        [
                    "nome" => $request->input("nome"),
                    "cnpj" => $request->input("cnpj")
                        ], [
                    "nome" => "required",
                    "cnpj" => "required"
                        ]
        );

        if ($validator->fails()) {
            return redirect()->action("EmpresaController@novo")->withInput()->withErrors($validator);
        }

        $user_id = Auth::user()->id;

        $empresa = Empresa::where('user_id', '=', $user_id)->where('cnpj', '=', $request->input("cnpj"))->first();
        if (count($empresa) == 0) {
            $empresa = new Empresa();
            $empresa->user_id = $user_id;
            $empresa->nome = $request->input("nome");
            $empresa->cnpj = $request->input("cnpj");
            $empresa->token = md5($request->input("cnpj"));
            $empresa->status = 1;
            $empresa->sincronizado = 0;
            $empresa->save();
        }
        return redirect('empresa/listar');
    }

    public function atualizar(Request $request, $id) {
        
        $validator = Validator::make(
                        [
                    "nome" => $request->input("nome"),
                    "cnpj" => $request->input("cnpj")
                        ], [
                    "nome" => "required",
                    "cnpj" => "required"
                        ]
        );

        if ($validator->fails()) {
            return redirect()->action("EmpresaController@editar",  array('id' => $id))->withInput()->withErrors($validator);
        }
        
        $user_id = Auth::user()->id;
        $user = Empresa::where('id', '<>', $id)->where('user_id', '=', $user_id)->where('cnpj', '=', $request->input("cnpj"))->first();
        if (count($user) == 0) {
            $empresa = Empresa::find($id);
            $empresa->user_id = $user_id;
            $empresa->nome = $request->input("nome");
            $empresa->cnpj = $request->input("cnpj");
            $empresa->token = md5($request->input("cnpj"));
            
            $empresa->status = (($request->input("status")) ? 1 : 0);
            $empresa->save();
        }
        return redirect('empresa/listar');
    }

    public function excluir($id) {
        try {
            Empresa::destroy($id);
            return redirect('empresa/listar');
        } catch (\PDOException $ex) {
            $mensagem = "";
            if ($ex->getCode() == 23000) {//caso possuir referencia em com outras tabelas
                $mensagem = "Não e possivel realizar a exclusão do registro pois existe relação com outros modulos.";
            } else {
                $mensagem = "Erro!";
            }
            return redirect('empresa/listar')->with('mensagem', $mensagem);
        }
    }

}
